<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('payment_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->integer('transaction_id')->nullable();
			$table->integer('transaction_status')->nullable();
			$table->integer('role_id')->unsigned()->nullable();
			$table->integer('package_id')->unsigned()->nullable();
			$table->integer('addition_id')->unsigned()->nullable();
			$table->float('total_amount')->nullable();
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_transactions');
	}
}