<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnnualActivationPriceLogsTable extends Migration {

	public function up()
	{
		Schema::create('annual_activation_price_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('activation_id')->unsigned()->nullable();
			$table->string('name', 500)->nullable();
			$table->float('price')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('annual_activation_price_logs');
	}
}