<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentLogsTable extends Migration {

	public function up()
	{
		Schema::create('payment_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->integer('payment_transaction_id')->unsigned()->nullable();
			$table->integer('status')->nullable();
			$table->float('total_amount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_logs');
	}
}