<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeriodsTable extends Migration {

	public function up()
	{
		Schema::create('periods', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('begin');
			$table->datetime('end');
			$table->boolean('allowed')->default(false);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('work_team_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('periods');
	}
}