<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Period extends Eloquent {

	protected $table = 'periods';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('allowed', 'work_team_id');
	protected $fillable = array('begin', 'end');

	public function slots()
	{
		return $this->hasMany('App\Entities\Tally\Work\Slot', 'slot_ids');
	}

}