<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operattions', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operattions', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->foreign('operattion_id')->references('id')->on('operattions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_installments', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_installments', function(Blueprint $table) {
			$table->foreign('installment_id')->references('id')->on('installments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('refunds', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('operattions', function(Blueprint $table) {
			$table->dropForeign('operattions_provider_id_foreign');
		});
		Schema::table('operattions', function(Blueprint $table) {
			$table->dropForeign('operattions_client_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_client_id_foreign');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->dropForeign('installments_operattion_id_foreign');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->dropForeign('installments_provider_id_foreign');
		});
		Schema::table('installments', function(Blueprint $table) {
			$table->dropForeign('installments_client_id_foreign');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_user_id_foreign');
		});
		Schema::table('invoice_installments', function(Blueprint $table) {
			$table->dropForeign('invoice_installments_invoice_id_foreign');
		});
		Schema::table('invoice_installments', function(Blueprint $table) {
			$table->dropForeign('invoice_installments_installment_id_foreign');
		});
		Schema::table('refunds', function(Blueprint $table) {
			$table->dropForeign('refunds_invoice_id_foreign');
		});
	}
}