<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('eventsid');
			$table->string('name', 256);
			$table->string('description', 256);
			$table->string('city', 256);
			$table->string('state', 256);
			$table->string('country', 256);
			$table->string('venue', 256);
			$table->string('address', 256);
			$table->integer('staffid')->unsigned();
			$table->date('date');
			$table->time('hour');
			$table->datetime('created');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}