<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('memberid')->references('memberid')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_question', function(Blueprint $table) {
			$table->foreign('staffid')->references('staffid')->on('staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_options', function(Blueprint $table) {
			$table->foreign('pollquestionid')->references('pollquestionid')->on('poll_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->foreign('pollquestionid')->references('pollquestionid')->on('poll_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->foreign('polloptionsid')->references('polloptionsid')->on('poll_options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->foreign('userid')->references('userid')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('staffid')->references('staffid')->on('staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news_comment', function(Blueprint $table) {
			$table->foreign('memberid')->references('memberid')->on('member')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news_comment', function(Blueprint $table) {
			$table->foreign('newsid')->references('newsid')->on('news')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('staffid')->references('staffid')->on('staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->foreign('eventsid')->references('eventsid')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->foreign('contactid')->references('contactid')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_memberid_foreign');
		});
		Schema::table('poll_question', function(Blueprint $table) {
			$table->dropForeign('poll_question_staffid_foreign');
		});
		Schema::table('poll_options', function(Blueprint $table) {
			$table->dropForeign('poll_options_pollquestionid_foreign');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->dropForeign('poll_answers_pollquestionid_foreign');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->dropForeign('poll_answers_polloptionsid_foreign');
		});
		Schema::table('poll_answers', function(Blueprint $table) {
			$table->dropForeign('poll_answers_userid_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_staffid_foreign');
		});
		Schema::table('news_comment', function(Blueprint $table) {
			$table->dropForeign('news_comment_memberid_foreign');
		});
		Schema::table('news_comment', function(Blueprint $table) {
			$table->dropForeign('news_comment_newsid_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_staffid_foreign');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->dropForeign('event_guests_eventsid_foreign');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->dropForeign('event_guests_contactid_foreign');
		});
	}
}