<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupSubjectTeacherTable extends Migration {

	public function up()
	{
		Schema::create('group_subject_teacher', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('teacher_id')->unsigned()->index();
			$table->integer('group_id')->unsigned()->index();
			$table->integer('subject_id')->unsigned()->index();
			$table->string('session', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('group_subject_teacher');
	}
}