<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchoolsTable extends Migration {

	public function up()
	{
		Schema::create('schools', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name');
			$table->text('logo')->nullable();
			$table->text('description')->nullable();
			$table->text('contact_no')->nullable();
			$table->text('email')->nullable();
			$table->string('owner')->nullable();
			$table->text('address')->nullable();
			$table->text('registration_no')->nullable();
			$table->string('pincode', 6)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('schools');
	}
}