<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParentTeacherChatTable extends Migration {

	public function up()
	{
		Schema::create('parent_teacher_chat', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('teacher_id')->unsigned()->index();
			$table->integer('student_id')->unsigned()->index();
			$table->text('message');
			$table->text('images')->nullable();
			$table->enum('type', array('t', 'p'));
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('parent_teacher_chat');
	}
}