<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentDetailsTable extends Migration {

	public function up()
	{
		Schema::create('student_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('student_id')->index();
			$table->integer('group_id')->unsigned()->index();
			$table->string('roll_number', 191)->index();
			$table->json('subjects')->nullable();
			$table->string('session', 50)->nullable()->index();
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('student_details');
	}
}