<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_details', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_subject_teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_subject_teacher', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parent_teacher_chat', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parent_teacher_chat', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_teacher_id_foreign');
		});
		Schema::table('student_details', function(Blueprint $table) {
			$table->dropForeign('student_details_group_id_foreign');
		});
		Schema::table('group_subject_teacher', function(Blueprint $table) {
			$table->dropForeign('group_subject_teacher_teacher_id_foreign');
		});
		Schema::table('group_subject_teacher', function(Blueprint $table) {
			$table->dropForeign('group_subject_teacher_group_id_foreign');
		});
		Schema::table('parent_teacher_chat', function(Blueprint $table) {
			$table->dropForeign('parent_teacher_chat_teacher_id_foreign');
		});
		Schema::table('parent_teacher_chat', function(Blueprint $table) {
			$table->dropForeign('parent_teacher_chat_student_id_foreign');
		});
	}
}