<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->index();
			$table->string('general_number', 191)->unique();
			$table->string('name', 190)->index();
			$table->string('middle_name', 191)->nullable()->index();
			$table->string('last_name', 190)->nullable()->index();
			$table->text('image')->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->string('contact_no', 191)->nullable()->index();
			$table->text('description')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}