<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class School extends Eloquent {

	protected $table = 'schools';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'logo', 'description', 'contact_no', 'email', 'owner', 'address', 'registration_no', 'pincode');
	protected $visible = array('name', 'logo');

	public function group()
	{
		return $this->hasMany('App\Group');
	}

	public function teacher()
	{
		return $this->hasMany('App\Teacher');
	}

}