<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('parent_id', 'general_number', 'name', 'middle_name', 'last_name', 'image', 'email', 'contact_no', 'description', 'active');
	protected $visible = array('parent_id', 'general_number', 'email', 'contact_no');

	public function studentDetail()
	{
		return $this->hasMany('App\StudentDetail', 'student_id');
	}

	public function teacherParentChat()
	{
		return $this->hasMany('App\ParentTeacherChat', 'student_id');
	}

	public function notification()
	{
		return $this->hasMany('App\Notification', 'student_id');
	}

	public function parentStudentDetail()
	{
		return $this->hasMany('App\Parent', 'student_id');
	}

	public function appreciation()
	{
		return $this->hasMany('App\Appreciation', 'student_id');
	}

}