<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppreciationsTable extends Migration {

	public function up()
	{
		Schema::create('appreciations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('teacher_id')->index();
			$table->integer('student_id')->index();
			$table->integer('subject_id')->unsigned()->nullable()->index();
			$table->text('subject');
			$table->text('message')->nullable();
			$table->text('images')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('appreciations');
	}
}