<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('teacher_id')->unsigned()->index();
			$table->integer('group_id')->index();
			$table->integer('student_id')->unsigned()->nullable()->index();
			$table->text('message');
			$table->text('images')->nullable();
			$table->enum('type', array('all', 'individual'));
			$table->timestamps();
			$table->text('subject')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}