<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ParentTeacherChat extends Model 
{

    protected $table = 'parent_teacher_chat';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('teacher_id', 'student_id', 'message', 'images', 'type', 'active');
    protected $visible = array('images');

    public function student()
    {
        return $this->belongsToMany('App\Student', 'student_id');
    }

    public function teacher()
    {
        return $this->belongsToMany('App\Teacher', 'teacher_id');
    }

}