<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Parent extends Model 
{

    protected $table = 'parents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('father_name', 'mother_name', 'email', 'password', 'contact_no', 'type', 'active');
    protected $visible = array('father_name', 'mother_name', 'email');

    public function student()
    {
        return $this->belongsToMany('App\Student');
    }

}