<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function skills()
	{
		return $this->belongsToMany('UserSkills');
	}

	public function role()
	{
		return $this->hasOne('UserRoles');
	}

}