<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Jobs extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function JobOffers()
	{
		return $this->hasMany('JobOffers');
	}

	public function JobStatus()
	{
		return $this->hasOne('JobStatuses');
	}

	public function Manager()
	{
		return $this->hasOne('Users');
	}

	public function Developer()
	{
		return $this->hasOne('Users');
	}

	public function Skills()
	{
		return $this->belongsToMany('JobSkills');
	}

}