<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stage extends Model 
{

    protected $table = 'stages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function stageWorkTypes()
    {
        return $this->hasMany('App\StageWorkType');
    }

    public function stagePartitions()
    {
        return $this->hasMany('App\StagePartition');
    }

    public function stageEmployees()
    {
        return $this->hasMany('App\Employee');
    }

}