<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBoardSettingsTable extends Migration {

	public function up()
	{
		Schema::create('board_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('board_id')->unsigned();
			$table->enum('plan_method', array('work_type', 'time_distribution'));
			$table->boolean('monday');
			$table->boolean('tuesday');
			$table->boolean('wednesday');
			$table->boolean('thursday');
			$table->boolean('friday');
			$table->boolean('saturday');
			$table->boolean('sunday');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('board_settings');
	}
}