<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanOrdersTable extends Migration {

	public function up()
	{
		Schema::create('plan_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->default('11');
			$table->date('start_date');
			$table->date('end_date');
			$table->date('deleted_date');
			$table->enum('status', array('open', 'gepland', 'inproductie', 'gereed'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plan_orders');
	}
}