<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stages', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('boards', function(Blueprint $table) {
			$table->foreign('id')->references('board_id')->on('stages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('boards', function(Blueprint $table) {
			$table->foreign('environment_id')->references('id')->on('environment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_employees', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_employees', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_work_types', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_partitions', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('relation_id')->references('id')->on('relation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('relation_id')->references('id')->on('relation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_rows', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_rows', function(Blueprint $table) {
			$table->foreign('inventory_id')->references('id')->on('inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->foreign('plan_order_id')->references('id')->on('plan_orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->foreign('assignee_user_id')->references('username')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_order_card_rows', function(Blueprint $table) {
			$table->foreign('plan_order_card_id')->references('id')->on('plan_order_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_order_card_rows', function(Blueprint $table) {
			$table->foreign('order_row_id')->references('id')->on('order_rows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('board_settings', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_schedules', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_employee_schedule', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stage_employee_schedule', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('stages', function(Blueprint $table) {
			$table->dropForeign('stages_board_id_foreign');
		});
		Schema::table('boards', function(Blueprint $table) {
			$table->dropForeign('boards_id_foreign');
		});
		Schema::table('boards', function(Blueprint $table) {
			$table->dropForeign('boards_environment_id_foreign');
		});
		Schema::table('stage_employees', function(Blueprint $table) {
			$table->dropForeign('stage_employees_stage_id_foreign');
		});
		Schema::table('stage_employees', function(Blueprint $table) {
			$table->dropForeign('stage_employees_employee_id_foreign');
		});
		Schema::table('stage_work_types', function(Blueprint $table) {
			$table->dropForeign('stage_work_types_stage_id_foreign');
		});
		Schema::table('stage_partitions', function(Blueprint $table) {
			$table->dropForeign('stage_partitions_stage_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_relation_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_relation_id_foreign');
		});
		Schema::table('order_rows', function(Blueprint $table) {
			$table->dropForeign('order_rows_order_id_foreign');
		});
		Schema::table('order_rows', function(Blueprint $table) {
			$table->dropForeign('order_rows_inventory_id_foreign');
		});
		Schema::table('plan_orders', function(Blueprint $table) {
			$table->dropForeign('plan_orders_order_id_foreign');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->dropForeign('plan_order_cards_plan_order_id_foreign');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->dropForeign('plan_order_cards_stage_id_foreign');
		});
		Schema::table('plan_order_cards', function(Blueprint $table) {
			$table->dropForeign('plan_order_cards_assignee_user_id_foreign');
		});
		Schema::table('plan_order_card_rows', function(Blueprint $table) {
			$table->dropForeign('plan_order_card_rows_plan_order_card_id_foreign');
		});
		Schema::table('plan_order_card_rows', function(Blueprint $table) {
			$table->dropForeign('plan_order_card_rows_order_row_id_foreign');
		});
		Schema::table('board_settings', function(Blueprint $table) {
			$table->dropForeign('board_settings_board_id_foreign');
		});
		Schema::table('employee_schedules', function(Blueprint $table) {
			$table->dropForeign('employee_schedules_employee_id_foreign');
		});
		Schema::table('stage_employee_schedule', function(Blueprint $table) {
			$table->dropForeign('stage_employee_schedule_stage_id_foreign');
		});
		Schema::table('stage_employee_schedule', function(Blueprint $table) {
			$table->dropForeign('stage_employee_schedule_employee_id_foreign');
		});
	}
}