<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stage extends Eloquent {

	protected $table = 'stages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function stageWorkTypes()
	{
		return $this->hasMany('App\StageWorkType');
	}

	public function stagePartitions()
	{
		return $this->hasMany('App\StagePartition');
	}

	public function stageEmployees()
	{
		return $this->hasMany('App\Employee');
	}

}