<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StageEmployee extends Eloquent {

	protected $table = 'stage_employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function stage()
	{
		return $this->belongsTo('App\Stage', 'id');
	}

	public function employee()
	{
		return $this->belongsTo('App\Employee', 'id');
	}

}