<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryTable extends Migration {

	public function up()
	{
		Schema::create('inventory', function(Blueprint $table) {
			$table->increments('id');
			$table->string('item');
			$table->string('code');
			$table->enum('type', array('product', 'component'));
			$table->string('warehouse');
			$table->string('location');
			$table->integer('in_stock');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inventory');
	}
}