<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderRowsTable extends Migration {

	public function up()
	{
		Schema::create('order_rows', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->default('11');
			$table->integer('inventory_id')->unsigned();
			$table->tinyInteger('position');
			$table->enum('type', array('activity', 'product'));
			$table->string('code');
			$table->string('description', 255);
			$table->float('quantitiy', 8,2);
			$table->enum('unit', array('hour', 'piece'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_rows');
	}
}