<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Commune extends Model 
{

    protected $table = 'communes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function villages()
    {
        return $this->hasMany('Village');
    }

    public function cercle()
    {
        return $this->belongsTo('Circle');
    }

}