<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Intervention extends Model 
{

    protected $table = 'interventions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function intervenant()
    {
        return $this->belongsTo('Organisation');
    }

    public function requests()
    {
        return $this->belongsToMany('Request')->withPivot('intervention_request');
    }

}