<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Province extends Model 
{

    protected $table = 'provinces';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function region()
    {
        return $this->belongsTo('Region');
    }

    public function circles()
    {
        return $this->hasMany('Circle');
    }

}