<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterventionsTable extends Migration {

	public function up()
	{
		Schema::create('interventions', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('organisation_id')->unsigned()->nullable();
			$table->timestampTz('date');
			$table->enum('status', array('pending', 'confirmed', 'canceled'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('interventions');
	}
}