<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrganisationsTable extends Migration {

	public function up()
	{
		Schema::create('organisations', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name');
			$table->enum('type', array('ngos', 'authorities', 'individuals'));
			$table->string('speciality')->nullable();
			$table->string('phone');
			$table->string('phone2')->nullable();
			$table->string('country')->nullable();
			$table->string('email');
			$table->integer('ngo_reference')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('organisations');
	}
}