<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('interventions', function(Blueprint $table) {
			$table->foreign('organisation_id')->references('id')->on('organisations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('village_id')->references('id')->on('villages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->foreign('commune_id')->references('id')->on('communes')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('intervention_request', function(Blueprint $table) {
			$table->foreign('intervention_id')->references('id')->on('organisations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('intervention_request', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('requests')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('communes', function(Blueprint $table) {
			$table->foreign('circle_id')->references('id')->on('circles')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('circles', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('provinces', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('interventions', function(Blueprint $table) {
			$table->dropForeign('interventions_organisation_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_village_id_foreign');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->dropForeign('villages_commune_id_foreign');
		});
		Schema::table('intervention_request', function(Blueprint $table) {
			$table->dropForeign('intervention_request_intervention_id_foreign');
		});
		Schema::table('intervention_request', function(Blueprint $table) {
			$table->dropForeign('intervention_request_request_id_foreign');
		});
		Schema::table('communes', function(Blueprint $table) {
			$table->dropForeign('communes_circle_id_foreign');
		});
		Schema::table('circles', function(Blueprint $table) {
			$table->dropForeign('circles_province_id_foreign');
		});
		Schema::table('provinces', function(Blueprint $table) {
			$table->dropForeign('provinces_region_id_foreign');
		});
		Schema::table('regions', function(Blueprint $table) {
			$table->dropForeign('regions_zone_id_foreign');
		});
	}
}