<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterventionRequestTable extends Migration {

	public function up()
	{
		Schema::create('intervention_request', function(Blueprint $table) {
			$table->integer('intervention_id')->unsigned()->nullable();
			$table->integer('request_id')->unsigned()->nullable();
			$table->double('quantity');
			$table->enum('quantity_unit', array('kg', 'liter', 'meter', 'other'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('intervention_request');
	}
}