<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Province extends Eloquent {

	protected $table = 'provinces';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function region()
	{
		return $this->belongsTo('Region');
	}

	public function circles()
	{
		return $this->hasMany('Circle');
	}

}