<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function interventions()
	{
		return $this->belongsToMany('Intervention')->withPivot('intervention_request');
	}

	public function village()
	{
		return $this->belongsTo('Village');
	}

}