<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVillagesTable extends Migration {

	public function up()
	{
		Schema::create('villages', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('commune_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('name_ar');
			$table->string('validated_by')->nullable();
			$table->datetimeTz('validated_at')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->integer('population')->nullable();
			$table->integer('families_count')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('villages');
	}
}