<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('cost');
			$table->text('note');
			$table->enum('status', array('pending', 'accepted', 'rejected', 'delivered', 'declined'));
			$table->integer('region_id')->unsigned();
			$table->string('address');
			$table->float('delivery_fee');
			$table->float('commission_fee');
			$table->float('total');
			$table->float('net');
			$table->integer('client_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}