<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('cost', 'note', 'status', 'region_id', 'address', 'delivery_fee', 'commission_fee', 'total', 'net');

	public function products()
	{
		return $this->belongsToMany('App\Models\Product')->withPivot('price','quantity','note');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}