<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('name', 'image', 'details', 'price', 'offer_price', 'restaurant_id', 'category_id');

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

}