<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function user_trees()
    {
        return $this->hasMany('Trees', 'owner_id');
    }

    public function users_attacks()
    {
        return $this->hasMany('Attacks', 'last_edited_by');
    }

    public function users_risks()
    {
        return $this->hasMany('Risks', 'last_edited_by');
    }

    public function users_categories()
    {
        return $this->hasMany('Categories', 'last_edited_by');
    }

    public function users_defences()
    {
        return $this->hasMany('Defences', 'last_edited_by');
    }

    public function users_trees()
    {
        return $this->belongsToMany('Trees');
    }

}