<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDefencesTable extends Migration {

	public function up()
	{
		Schema::create('defences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('last_edited_by')->unsigned()->nullable();
			$table->boolean('locked');
			$table->string('text');
			$table->enum('type', array('mitigation', 'transfer'));
			$table->boolean('existing');
		});
	}

	public function down()
	{
		Schema::drop('defences');
	}
}