<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('last_edited_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('tree_id')->references('id')->on('trees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('risks', function(Blueprint $table) {
			$table->foreign('last_edited_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('risks', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attacks', function(Blueprint $table) {
			$table->foreign('last_edited_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('attacks', function(Blueprint $table) {
			$table->foreign('risk_id')->references('id')->on('risks')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('defences', function(Blueprint $table) {
			$table->foreign('last_edited_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('attack_defence', function(Blueprint $table) {
			$table->foreign('attack_id')->references('id')->on('attacks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attack_defence', function(Blueprint $table) {
			$table->foreign('defence_id')->references('id')->on('defences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trees', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_tree', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('trees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_tree', function(Blueprint $table) {
			$table->foreign('tree_id')->references('id')->on('trees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_last_edited_by_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_tree_id_foreign');
		});
		Schema::table('risks', function(Blueprint $table) {
			$table->dropForeign('risks_last_edited_by_foreign');
		});
		Schema::table('risks', function(Blueprint $table) {
			$table->dropForeign('risks_category_id_foreign');
		});
		Schema::table('attacks', function(Blueprint $table) {
			$table->dropForeign('attacks_last_edited_by_foreign');
		});
		Schema::table('attacks', function(Blueprint $table) {
			$table->dropForeign('attacks_risk_id_foreign');
		});
		Schema::table('defences', function(Blueprint $table) {
			$table->dropForeign('defences_last_edited_by_foreign');
		});
		Schema::table('attack_defence', function(Blueprint $table) {
			$table->dropForeign('attack_defence_attack_id_foreign');
		});
		Schema::table('attack_defence', function(Blueprint $table) {
			$table->dropForeign('attack_defence_defence_id_foreign');
		});
		Schema::table('trees', function(Blueprint $table) {
			$table->dropForeign('trees_owner_id_foreign');
		});
		Schema::table('user_tree', function(Blueprint $table) {
			$table->dropForeign('user_tree_user_id_foreign');
		});
		Schema::table('user_tree', function(Blueprint $table) {
			$table->dropForeign('user_tree_tree_id_foreign');
		});
	}
}