<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type');
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('details_en');
			$table->string('details_ar');
			$table->timestamps();
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}