<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EntityBranches extends Model 
{

    protected $table = 'entity_branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('uuid', 'street_no', 'city', 'zip_code', 'state', 'cuisine', 'service_id', 'publish_merchant', 'status_id', 'entity_id');

    public function services()
    {
        return $this->hasOne('Services', 'service_id');
    }

    public function status()
    {
        return $this->hasMany('Status', 'status_id');
    }

    public function Entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

}