<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sponsored extends Model 
{

    protected $table = 'sponsored';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('entity_id', 'status', 'start_date', 'end_date');

    public function entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

}