<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ads extends Eloquent {

	protected $table = 'ads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image', 'start_date_time', 'end_date_time');

	public function entity()
	{
		return $this->hasOne('Entities', 'entity_id');
	}

}